/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;
import data.structures.resources.RessourceItem;
import data.structures.tagging.LemmaInfos;
import data.structures.tagging.LemmaVector;

import proc.tagging.TreeTagger;
import proc.text.Codecs;

import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class DBPediaDatabase {

    //private List ignoreLemma;
    private Database theDB;

    public DBPediaDatabase(Database db){
        theDB = db;
        /*ignoreLemma = new ArrayList();
        try {
            getIgnoreLemma();
        } catch (SQLException ex) {
            ex.printStackTrace();
        }*/
    }
    /*public int insertRessource(String yago_url, String dbpedia_url){
        RessourceRetrieval content = new RessourceRetrieval();
        //recupération des entrées spécifiées
        ArrayList result = content.getDesc(dbpedia_url.replaceAll("'", "&#39;"));
        //conversions
        String label = result.get(0).toString().replaceAll("@fr", " ");
        String abstr = result.get(1).toString().replaceAll("@fr", " ");
        //insertions
        String query = String.format("INSERT INTO ipri_dbpedia_ressources(yago_url, dbpedia_url, label, abstract)  VALUES('%s', '%s', '%s', '%s')",
                yago_url.replaceAll("'", "&#39;"),
                dbpedia_url.replaceAll("'", "&#39;"),
                Codes.escapeHTML(label),
                Codes.escapeHTML(abstr));
        return theDB.ExecuteUpdate(query);
        return 0;
    }*/
    /*public int setRessource(String url){
        _SemanticStorage content = new _SemanticStorage();
        //recupération des entrées spécifiées
        ArrayList result = content.getDesc(url.replaceAll("'", "&#39;"));
        //conversions
        String label = result.get(0).toString().replaceAll("@fr", " ");
        String abstr = result.get(1).toString().replaceAll("@fr", " ");
        //insertions
        String query = String.format("INSERT INTO ipri_ressource(url, nom, desc)  VALUES('%s', '%s', '%s')",
                url.replaceAll("'", "&#39;"),
                Codecs.escapeHTML(label),
                Codecs.escapeHTML(abstr));
        return theDB.executeInsertOrUpdate(query);
    }*/
    /*public void updateAllDesc(){
        _SemanticStorage rr = new _SemanticStorage();
        //get all the url
        HashMap ressources = getAllRessources();
        Iterator iter = ressources.keySet().iterator();
        while(iter.hasNext())
        {
            //recupération des identifiants et url
            Object clef = iter.next();
            String url = (String) ressources.get(clef);
            int id = Integer.parseInt(clef.toString());
            //recupération du résumé
            ArrayList resSet = rr.getDesc(url);
            String abstr = Codecs.escapeHTML(resSet.get(1).toString().replaceAll("@fr", " "));
            //insertion
            String query = String.format("UPDATE ipri_ressource SET `desc` = '"+abstr+"' WHERE `id_ressource` = "+id+"");
            theDB.executeInsertOrUpdate(query);
        }
        System.out.println("-------DONE---------");
    }*/
    
    private HashMap getAllRessources() throws NoBaseException {
        HashMap result = new LinkedHashMap();
        //get all the url
        String query = String.format("SELECT id, uri FROM onto_concepts");
        ResultSet rs = theDB.executeSelection(query);
        try {
            while (rs.next()) {
                String url = Codecs.desEscapeHTML(rs.getString("uri"));
                int id = rs.getInt("id");
                result.put(id, url);
            }
        } catch (SQLException e) {
            System.out.println("error on " + e.toString());
        }
        return result;
    }

     public Set<RessourceItem> getAllRessourcesItems() throws NoBaseException {
        String query = String.format("SELECT * FROM ipri_ressource");
        ResultSet rs = theDB.executeSelection(query);
        Set<RessourceItem> items = new LinkedHashSet<RessourceItem>();
        try {
            while (rs.next()) {
                RessourceItem ri = new RessourceItem();
                ri.setRessourceID(rs.getInt("id_ressource"));
                ri.setUrl(Codecs.desEscapeHTML(rs.getString("url")));
                ri.setNom(Codecs.desEscapeHTML(rs.getString("nom")));
                ri.setDesc(Codecs.desEscapeHTML(rs.getString("desc")));
                items.add(ri);
            }
        } catch (SQLException e) {
            System.out.println("error on get ressource last key " + e.toString());
        }
        return items;
    }
    public int UpdateLemmas(RessourceItem item) throws NoBaseException {
        String query = String.format("UPDATE ipri_ressource SET desc_lemmes = '%s' WHERE id_ressource = %d LIMIT 1",
                Codecs.escapeHTML(item.getDescLemmas()),
                item.getRessourceID());
        return theDB.executeInsertOrUpdate(query);
    }

    public Set<RessourceItem> getRelatedItems(int rssID) throws NoBaseException {
        String query = String.format("SELECT id_ressource FROM ipri_ressource_item WHERE id_rssitem = "+rssID+"");
        ResultSet rs = theDB.executeSelection(query);
        Set<RessourceItem> keys = new LinkedHashSet<RessourceItem>();
        Set<RessourceItem> items = new LinkedHashSet<RessourceItem>();
        try {
            while (rs.next()) {
                RessourceItem ri = new RessourceItem();
                ri.setRessourceID(rs.getInt("id_ressource"));
                keys.add(ri);
            }
        } catch (SQLException e) {
            System.out.println("error on get ressource last key " + e.toString());
        }
        Iterator iter = keys.iterator();
        while(iter.hasNext()){
            RessourceItem ri = (RessourceItem) iter.next();
            ri = getRessourceItem(ri.getRessourceID());
            items.add(ri);
        }
        return items;
    }

    public RessourceItem getRessourceItem(int ressource_id) throws NoBaseException {
        RessourceItem myItem = new RessourceItem();
        String query = String.format("SELECT * FROM ipri_ressource WHERE id_ressource="+ressource_id+" LIMIT 1");
        ResultSet rs = theDB.executeSelection(query);
        try {
            while (rs.next()) {
                myItem.setRessourceID(rs.getInt("id_ressource"));
                myItem.setUrl(Codecs.desEscapeHTML(rs.getString("url")));
                myItem.setNom(Codecs.desEscapeHTML(rs.getString("nom")));
                myItem.setDesc(Codecs.desEscapeHTML(rs.getString("desc")));
                myItem.setDescLemmas(Codecs.desEscapeHTML(rs.getString("desc_lemmes")));
            }
        } catch (SQLException e) {
            System.out.println("error on get ressource last key " + e.toString());
        }
        return myItem;
    }

    public int InsertLemma(int idThema, String lemma, int nbTitle, int nbDesc) throws NoBaseException {
//        if(!unwantedLemma(lemma)){
            String query = String.format("INSERT INTO ipri_ressource(idThema,lemme,countTitle,countDesc)  VALUES ("+idThema+",'%s',%d,%d)",
                    Codecs.escapeHTML(lemma), nbTitle, nbDesc);
            return theDB.executeInsertOrUpdate(query);
//        }
//        else return(0);
    }

    public void resetPages() throws NoBaseException {
        System.err.print("bouh");
        String query = "DELETE FROM onto_lemmesfr WHERE concept IN {SELECT id FROM onto_concepts WHERE ontologie=1};";
        theDB.executeDeletion(query);
        String query2 = "DELETE FROM onto_lemmesen WHERE concept IN {SELECT id FROM onto_concepts WHERE ontologie=1};";
        theDB.executeDeletion(query2);
        String query3 = "DELETE FROM onto_relations WHERE ontologie=1;";
        theDB.executeDeletion(query3);
        String query4 = "DELETE FROM onto_concepts WHERE ontologie=1;";
        theDB.executeDeletion(query4);
        //resetOptimisationConcepts();
        System.err.print("bouh");
    }

    public int storeLabelPage(String label, String concept) throws NoBaseException {
        String query = "INSERT INTO onto_concepts(ontologie, uri, " +
                "titreFR, descriptionFR, titreEN, descriptionEN," +
                "titreLemmaFR, descLemmaFR, titreLemmaEN, descLemmaEN) VALUES (1, '"+
                Codecs.escapeHTML(concept)+"', '"+Codecs.escapeHTML(label)+"'," +
                " '', '', '', '', '', '', '');";
        return theDB.executeInsertOrUpdate(query);
    }

    public int storeDescriptionPage(String desc, String concept) throws NoBaseException {
        String query = "UPDATE onto_concepts SET descriptionFR='"+
                Codecs.escapeHTML(desc)+"' WHERE uri='"+
                Codecs.escapeHTML(concept)+"' AND ontologie=1;";
        return theDB.executeInsertOrUpdate(query);
    }

    public int getConceptsCount() throws NoBaseException {
        String query = String.format("SELECT MAX(id) FROM onto_concepts WHERE ontologie=1");
        ResultSet rs = theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        } catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        return res;
    }

    public void lieConceptOntologie(int id) throws NoBaseException {
        String query = "SELECT ConceptName FROM ipri_onto_concepts WHERE ResourceID=2";
        ResultSet rs = theDB.executeSelection(query);
        String res = null;
        try {
            if (rs.next()) {
                res = rs.getString(1);
            }
        } catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        if(res==null){
            return; // Lien effectué : rien à lier
        }
        String query2 = "SELECT CategorieName FROM ipri_onto_categories WHERE ConceptName='"+
                Codecs.escapeHTML(res)+"';";
        ResultSet rs2 = theDB.executeSelection(query2);
        Vector<String> res2 = new Vector<String>();
        try {
            while (rs2.next()) {
                res2.addElement(rs2.getString(1));
            }
        } catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        for(int i=0; i<res2.size(); i++){
            String query3 = "SELECT id FROM ipri_ontologie WHERE ressource='"+
                    Codecs.escapeHTML(res2.elementAt(i))+"' AND ressourceId=2;";
            ResultSet rs3 = theDB.executeSelection(query3);
            int res3 = 0;
            try {
                if (rs3.next()) {
                    res3 = rs3.getInt(1);
                }
            } catch (SQLException e) {
                System.out.println("error on get count " + e.toString());
            }
            String query4 = "INSERT INTO ipri_onto_con_cate_onto(idConcept, idCateOnto, idRessource) VALUES ("+
                    id+", "+res3+", 2);";
            theDB.executeInsertOrUpdate(query4);
        }
    }

    public void lieConceptWikipedia(int id) throws NoBaseException {
        String query = "SELECT ConceptName FROM ipri_onto_concepts WHERE ResourceID=2";
        ResultSet rs = theDB.executeSelection(query);
        String res = null;
        try {
            if (rs.next()) {
                res = rs.getString(1);
            }
        } catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        if(res==null){
            return; // Lien effectué : rien à lier
        }
        String query2 = "SELECT CategorieName FROM ipri_onto_categories2 WHERE ConceptName='"+
                Codecs.escapeHTML(res)+"';";
        ResultSet rs2 = theDB.executeSelection(query2);
        Vector<String> res2 = new Vector<String>();
        try {
            while (rs2.next()) {
                res2.addElement(rs2.getString(1));
            }
        } catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        for(int i=0; i<res2.size(); i++){
            String query3 = "SELECT idCategorie FROM ipri_onto_cate_labels WHERE CategorieName='"+
                    Codecs.escapeHTML(res2.elementAt(i))+"' AND idRessource=2;";
            ResultSet rs3 = theDB.executeSelection(query3);
            int res3 = 0;
            try {
                if (rs3.next()) {
                    res3 = rs3.getInt(1);
                }
            } catch (SQLException e) {
                System.out.println("error on get count " + e.toString());
            }
            String query4 = "INSERT INTO ipri_onto_con_cate_wiki(idConcept, idCateWiki, idRessource) VALUES ("+
                    id+", "+res3+", 2);";
            theDB.executeInsertOrUpdate(query4);
        }
    }

    public int getLastConceptLieOnto() throws NoBaseException {
        String query = String.format("SELECT MAX(idConcept) " +
                "FROM ipri_onto_con_cate_onto WHERE idRessource=2;");
        ResultSet rs = theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        } catch (SQLException e) {
            System.out.println("error on get last linked concept " + e.toString());
        } catch(NullPointerException npe){

        }
        return res;
    }

    public int getLastConceptLieWiki() throws NoBaseException {
        String query = String.format("SELECT MAX(idConcept) " +
                "FROM ipri_onto_con_cate_wiki WHERE idRessource=2;");
        ResultSet rs = theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        } catch (SQLException e) {
            System.out.println("error on get last linked concept " + e.toString());
        } catch(NullPointerException npe){

        }
        return res;
    }

    public void resetOptimisationConcepts() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_con_cate_onto;";
        theDB.executeDeletion(query);
        query = "DELETE FROM ipri_onto_con_cate_wiki;";
        theDB.executeDeletion(query);
    }

    public int getLastLemmatizedConcept() throws NoBaseException {
        String query = String.format("SELECT MAX(l.concept) FROM onto_concepts c, " +
                "onto_lemmesfr l WHERE c.id=l.concept AND c.ontologie=1;");
        ResultSet rs = theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        } catch (SQLException e) {
            System.out.println("error on get last lemmatized concept " + e.toString());
        } catch(NullPointerException npe){

        }
        return res;
    }

    private TreeTagger tt = new TreeTagger();
    public void lemmatiseConcept(int id) throws NoBaseException {
        String query = "SELECT titreFR, descriptionFR FROM onto_concepts WHERE id="+id+" AND ontologie=1;";
        ResultSet rs = theDB.executeSelection(query);
        String label = "";
        String desc = "";
        try {
            if (rs.next()) {
                label = Codecs.desEscapeHTML(rs.getString("titreFR"));
                desc = Codecs.desEscapeHTML(rs.getString("descriptionFR"));
            }
        } catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        LemmaVector lemmasLabel = tt.processText(label);
        LemmaVector lemmasDesc = tt.processText(desc);
        storeLemmasConcept(id, lemmasLabel, lemmasDesc);
    }

    public int getCategoriesCount() throws NoBaseException {
        String query = String.format("SELECT MAX(idCategorie) FROM ipri_onto_cate_labels WHERE idRessource=2");
        ResultSet rs = theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        } catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        return res;
    }

    public int getLastLemmatizedCategorie() throws NoBaseException {
        String query = String.format("SELECT MAX(l.idCategorie) FROM ipri_onto_cate_labels c, " +
                "ipri_onto_cate_lemmes_en l WHERE c.idCategorie=l.idCategorie AND c.idRessource=2;");
        ResultSet rs = theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        } catch (SQLException e) {
            System.out.println("error on get last lemmatized concept " + e.toString());
        } catch(NullPointerException npe){

        }
        return res;
    }

    private TreeTagger tt2 = new TreeTagger(TreeTagger.EN);
    public void lemmatiseCategorie(int id) throws NoBaseException {
        String query = String.format("SELECT idRessource, CategorieLabel FROM ipri_onto_cate_labels WHERE idCategorie="+id);
        ResultSet rs = theDB.executeSelection(query);
        int res = 0;
        String label = "";
        try {
            if (rs.next()) {
                res = rs.getInt("idRessource");
                label = Codecs.desEscapeHTML(rs.getString("CategorieLabel"));
            }
        } catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        if(res != 2){
            // Pas de lemmatisation si la ressource n'est pas DBPedia.
            return;
        }
        LemmaVector lemmasLabel = tt2.processText(label);
        storeLemmasCategorie(id, lemmasLabel);
    }

    public void resetCategories() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_categories;";
        theDB.executeDeletion(query);
    }

    public int storeCategorie(String concept, String categorie) throws NoBaseException {
        String query = "INSERT INTO ipri_onto_categories(ConceptName, CategorieName) VALUES('"+
                Codecs.escapeHTML(concept)+"', '"+Codecs.escapeHTML(categorie)+"');";
        return theDB.executeInsertOrUpdate(query);
    }

    public void resetCategories2() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_categories2;";
        theDB.executeDeletion(query);
        resetOptimisationConcepts();
    }

    public int storeCategorie2(String concept, String categorie) throws NoBaseException {
        String query = "INSERT INTO ipri_onto_categories2(ConceptName, CategorieName) VALUES('"+
                Codecs.escapeHTML(concept)+"', '"+Codecs.escapeHTML(categorie)+"');";
        return theDB.executeInsertOrUpdate(query);
    }

    public void resetLabelsCategories() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_cate_labels WHERE idRessource=2;";
        theDB.executeDeletion(query);
        resetOptimisationConcepts();
    }

    public int storeLabelCategorie(String concept, String categorie) throws NoBaseException {
        String query = "INSERT INTO ipri_onto_cate_labels(CategorieName, CategorieLabel, " +
                "idRessource) VALUES('"+
                Codecs.escapeHTML(concept)+"', '"+Codecs.escapeHTML(categorie)+"', 2);";
        return theDB.executeInsertOrUpdate(query);
    }
    
    public void resetOntologie() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_lemmes_en WHERE idConcept IN " +
                "(SELECT id FROM ipri_ontologie WHERE ressourceId=2);";
        theDB.executeDeletion(query);
        String query2 = "DELETE FROM ipri_relation WHERE idSemantic_ressources=2;";
        theDB.executeDeletion(query2);
        String query3 = "DELETE FROM ipri_ontologie WHERE ressourceId=2;";
        theDB.executeDeletion(query3);
        resetOptimisationConcepts();
    }

    private TreeTagger tte = new TreeTagger(TreeTagger.EN);
    public void storeClasse(String classe, String label) throws NoBaseException {
        String query1 = "INSERT INTO ipri_ontologie(ressource, nom, ressourceId) VALUES ('" +
                Codecs.escapeHTML(classe) + "', '" + Codecs.escapeHTML(label) + "', 2);";
        theDB.executeInsertOrUpdate(query1);
        String queryConcept = "SELECT id FROM ipri_ontologie WHERE ressource='"+
                Codecs.escapeHTML(classe)+"';";
        ResultSet rsCon = theDB.executeSelection(queryConcept);
        int idConcept = -1;
        try {
            if (rsCon.next()) {
                idConcept = rsCon.getInt("id");
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        LemmaVector lemmas = tte.processText(label);
        Vector<LemmaInfos> liste = lemmas.getLemmas();
        Map<LemmaInfos, Integer> lemmasCount = lemmas.toLemmasCount();
        for (int i = 0; i < liste.size(); i++) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            if (!unwantedLemma(lemma)) {
                String queryLemma = "INSERT INTO ipri_onto_lemmes_en(idConcept, lemme, " +
                        "countTitle, countDesc, Lex) VALUES(" +
                        idConcept + ", '" + Codecs.escapeHTML(lemma) + "', " +
                        lemmasCount.get(liste.elementAt(i)) + ", " + 0 +
                        ", '" + lex + "');";
                theDB.executeInsertOrUpdate(queryLemma);
            }
        }
    }

    public void storeRelation(String classe, String categorie) throws NoBaseException {
        String queryConcept = "SELECT id FROM ipri_ontologie WHERE ressource='"+
                Codecs.escapeHTML(classe)+"';";
        ResultSet rsCon = theDB.executeSelection(queryConcept);
        int idConcept = -1;
        try {
            if (rsCon.next()) {
                idConcept = rsCon.getInt("id");
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        if(idConcept==-1){
            return;
        }
        String queryCategorie = "SELECT id FROM ipri_ontologie WHERE ressource='"+
                Codecs.escapeHTML(categorie)+"';";
        ResultSet rsCat = theDB.executeSelection(queryCategorie);
        int idCategorie = -1;
        try {
            if (rsCat.next()) {
                idCategorie = rsCat.getInt("id");
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        if(idCategorie == -1){
            String queryInsCat = "INSERT INTO ipri_ontologie(ressource, nom, ressourceId) VALUES('"+
                    Codecs.escapeHTML(categorie)+"', '', 2);";
            theDB.executeInsertOrUpdate(queryInsCat);
        }
        ResultSet rsCat2 = theDB.executeSelection(queryCategorie);
        try {
            if (rsCat2.next()) {
                idCategorie = rsCat2.getInt("id");
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        if(idCategorie==-1){
            //On n'y peut rien, là.
            return;
        }
        String query = "INSERT INTO ipri_relation(ConceptID1, RelationType, ConceptID2, idSemantic_ressources) VALUES ("+
                idCategorie+", 'generalise', "+idConcept+", 2);";
        theDB.executeInsertOrUpdate(query);
    }



    private void storeLemmasConcept(int itemId, LemmaVector title, LemmaVector desc){

        Map<LemmaInfos, Integer> lemmasCountTitle = title.toLemmasCount();
        Map<LemmaInfos, Integer> lemmasCountDesc = desc.toLemmasCount();
        // for each title lemma
        Vector<LemmaInfos> liste = title.getLemmas();
        for (int i = 0; i<liste.size(); i++) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            if (lemmasCountDesc.containsKey(liste.elementAt(i))) { // dans le titre et dans la description
                try{
                    insertLemmaConcept(itemId, lemma, lemmasCountTitle.get(liste.elementAt(i)),
                            lemmasCountDesc.get(liste.elementAt(i)), lex);
                }catch (Exception ex){
                    //debug
                    System.out.println(String.format("Lemme title+desc insert problem :"+ex.getMessage()));
                }
            } else {
                try{
                    insertLemmaConcept(itemId, lemma, lemmasCountTitle.get(liste.elementAt(i)), 0, lex);
                }catch (Exception ex){
                    //debug
                    System.out.println(String.format("Lemme title insert problem :"+ex.getMessage()));
                }
            }
        }
        // for each description lemma
        liste = desc.getLemmas();
        for (int i = 0; i<liste.size(); i++) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            if (!lemmasCountTitle.containsKey(liste.elementAt(i))) {
                try{
                    insertLemmaConcept(itemId, lemma, 0, lemmasCountDesc.get(liste.elementAt(i)), lex);
                }catch (Exception ex){
                    //debug
                    System.out.println(String.format("Lemme desc insert problem :"+ex.getMessage()));
                }
            }
        }
    }

    private void storeLemmasCategorie(int itemId, LemmaVector label){

        Map<LemmaInfos, Integer> lemmasCountLabel = label.toLemmasCount();

        Vector<LemmaInfos> liste = label.getLemmas();
        for (int i = 0; i<liste.size(); i++) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            try {
                insertLemmaCategorie(itemId, lemma, lemmasCountLabel.get(liste.elementAt(i)), lex);
            } catch (Exception ex) {
                //debug
                System.out.println(String.format("Lemme title insert problem :" + ex.getMessage()));
            }
        }
    }

    private void insertLemmaConcept(int id, String lemma, int a, int b, String lex) throws NoBaseException {
        if (!unwantedLemma(lemma)) {
            String queryLemma = "INSERT INTO onto_lemmesfr(concept, lemme, " +
                    "occuTitre, occuDesc, nature) VALUES(" +
                    id + ", '" + Codecs.escapeHTML(lemma) + "', " + a + ", " + b + 
                    ", '"+ Codecs.escapeHTML(lex) +"');";
            theDB.executeInsertOrUpdate(queryLemma);
        }
    }

    private void insertLemmaCategorie(int id, String lemma, int a, String lex) throws NoBaseException {
        if (!unwantedLemma(lemma)) {
            String queryLemma = "INSERT INTO onto_lemmesen(concept, lemme, " +
                    "occuTitre, occuDesc, nature) VALUES(" +
                    id + ", '" + Codecs.escapeHTML(lemma) + "', " + a + ", 0, '" +
                    Codecs.escapeHTML(lex) + "');";
            theDB.executeInsertOrUpdate(queryLemma);
        }
    }

    private boolean unwantedLemma(String lemma) {
        //On n'utilise plus cette méthode qui élimine des lemmes utiles.
        //De toute façon, les lemmes sont éliminés par leur nature.
        return false;
        /*// aucun lemme de taille 1 n'est souhaitable (de toute façon, a/à/y sont éliminés ensuite)
        if(lemma.length()<2){
            return true;
        }
        // detection par le corpus de termes de la table ipri_lemmes_ignore
        if (ignoreLemma.contains(lemma)) {
            //System.out.println("lemme refusé: "+lemma);
            return true;
        }
        // elimination des valeurs numeriques extravagantes
        List weirdLemma = new ArrayList();
        weirdLemma.add("$");
        weirdLemma.add("&");
        weirdLemma.add("#");
        weirdLemma.add("+");
        weirdLemma.add("/");
        weirdLemma.add("@");
        weirdLemma.add("(");
        weirdLemma.add(")");
        weirdLemma.add("*");
        for (int i = 0; i < weirdLemma.size(); i++) {
            if (lemma.contains((CharSequence) weirdLemma.get(i))) {
                //System.out.println("lemme refusé : "+lemma);
                return true;
            }
        }
        return false;*/
    }

    /*private void getIgnoreLemma() throws SQLException {
        String query = String.format("SELECT lemme FROM ipri_lemmes_ignore");
        ResultSet rs = theDB.executeSelection(query);
        try {
            while (rs.next()) {
                ignoreLemma.add(rs.getString(1));
            }
            rs.close();
        } catch (SQLException e) {
            System.out.println("error retrieving lemmas to ignore");
            throw e;
        }
    }*/
}
